/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4648;
import net.minecraft.class_4651;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import twilightforest.util.FeaturePlacers;
import twilightforest.world.registration.TwilightFeatures;

public class LeafSpheroidFoliagePlacer
extends class_4647 {
    public static final Codec<LeafSpheroidFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("horizontal_radius").forGetter(o -> Float.valueOf(o.horizontalRadius)), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("vertical_radius").forGetter(o -> Float.valueOf(o.verticalRadius)), (App)class_6017.method_35004((int)0, (int)8).fieldOf("offset").forGetter(obj -> obj.field_23753), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_horizontal").orElse((Object)0).forGetter(o -> o.randomHorizontal), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_vertical").orElse((Object)0).forGetter(o -> o.randomVertical), (App)Codec.floatRange((float)-0.5f, (float)0.5f).fieldOf("vertical_filler_bias").orElse((Object)Float.valueOf(0.0f)).forGetter(o -> Float.valueOf(o.verticalBias)), (App)Codec.intRange((int)0, (int)256).fieldOf("shag_factor").orElse((Object)0).forGetter(o -> o.shag_factor)).apply((Applicative)instance, LeafSpheroidFoliagePlacer::new));
    private final float horizontalRadius;
    private final float verticalRadius;
    private final float verticalBias;
    private final int randomHorizontal;
    private final int randomVertical;
    private final int shag_factor;

    public LeafSpheroidFoliagePlacer(float horizontalRadius, float verticalRadius, class_6017 yOffset, int randomHorizontal, int randomVertical, float verticalBias, int shag_factor) {
        super((class_6017)class_6016.method_34998((int)((int)horizontalRadius)), yOffset);
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.randomHorizontal = randomHorizontal;
        this.randomVertical = randomVertical;
        this.verticalBias = verticalBias;
        this.shag_factor = shag_factor;
    }

    protected class_4648<LeafSpheroidFoliagePlacer> method_28843() {
        return (class_4648)TwilightFeatures.FOLIAGE_SPHEROID.get();
    }

    protected void method_23448(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, Random random, class_4643 baseTreeFeatureConfig, int trunkHeight, class_4647.class_5208 foliage, int foliageHeight, int radius, int offset) {
        class_2338 center = foliage.method_27388().method_10086(offset);
        FeaturePlacers.placeSpheroid(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, random, center, (float)foliage.method_27389() + this.horizontalRadius + (float)random.nextInt(this.randomHorizontal + 1), (float)foliage.method_27389() + this.verticalRadius + (float)random.nextInt(this.randomVertical + 1), this.verticalBias, baseTreeFeatureConfig.field_29280);
        if (this.shag_factor > 0) {
            for (int i = 0; i < this.shag_factor; ++i) {
                float randomYaw = random.nextFloat() * ((float)Math.PI * 2);
                float randomPitch = random.nextFloat() * 2.0f - 1.0f;
                float yUnit = class_3532.method_15355((float)(1.0f - randomPitch * randomPitch));
                float xCircleOffset = yUnit * class_3532.method_15362((float)randomYaw) * (this.horizontalRadius - 1.0f);
                float zCircleOffset = yUnit * class_3532.method_15374((float)randomYaw) * (this.horizontalRadius - 1.0f);
                class_2338 placement = center.method_10080((double)(xCircleOffset + (float)((int)xCircleOffset >> 31)), (double)(randomPitch * (this.verticalRadius + 0.25f) + this.verticalBias), (double)(zCircleOffset + (float)((int)zCircleOffset >> 31)));
                LeafSpheroidFoliagePlacer.placeLeafCluster(worldReader, worldPlacer, random, placement.method_10062(), baseTreeFeatureConfig.field_29280);
            }
        }
    }

    private static void placeLeafCluster(class_3746 worldReader, BiConsumer<class_2338, class_2680> worldPlacer, Random random, class_2338 pos, class_4651 state) {
        FeaturePlacers.placeProvidedBlock(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, pos, state, random);
        FeaturePlacers.placeProvidedBlock(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, pos.method_10078(), state, random);
        FeaturePlacers.placeProvidedBlock(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, pos.method_10072(), state, random);
        FeaturePlacers.placeProvidedBlock(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, pos.method_10069(1, 0, 1), state, random);
    }

    public int method_26989(Random random, int i, class_4643 baseTreeFeatureConfig) {
        return 0;
    }

    protected boolean method_23451(Random random, int i, int i1, int i2, int i3, boolean b) {
        return false;
    }
}

